;/*************************************************
; Program			:4x4 Keypad
; Description		:scan 4x4 Keypad and display its key pressed value 
;					:at PC' Monitior. MCU Port, PB3..PB0 are output port
;					:and PB7..PB4 are input port.
; CPU Control		:ATmega163
; File name			:key4x4.asm
; Assembler			:AVR Studio 4.05
; 
;**************************************************

.include "m163def.inc"			
			.org   	$000 
    		rjmp  reset			;Reset Handle
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		Column		= r20
.def		data		= r21
.def		temp1		= r22
;/***********************
; Define I/O Port,Pin
;/***********************
.equ		PORT_KBI	= PORTB
.equ		DDR_KBI		= DDRB
.equ		PIN_KBI		= PINB
.equ		Col		= 16
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	
main:		sbi	UCR,TXEN
			sbi	UCR,RXEN
			ldi	temp,51				;baudrate = 9600 bps 
			out	UBRR,temp

Key4x4:		ldi	ZH,high(2*Key4x4TB)		
			ldi	ZL,low(2*Key4x4TB)
			rcall	Intro
wait_key:	rcall	scan_key		;scan keypad
			brts	dsp_key
			rjmp	wait_key

;/******************************************
; convert keypad code to ascii code
;/******************************************
dsp_key:	cpi	data,$0A			;if data < 10 jump to dsp_key2 label
			brlo	dsp_key1		
			subi	data,-$37		;data = data+$37
			rcall	TX_Byte
			ldi	data,' '
			rcall	TX_Byte
			rcall	delay200ms
			rjmp	wait_key
dsp_key1:	subi	data,-$30		;data = data+$30
			rcall	TX_Byte
			ldi	data,' '
			rcall	TX_Byte
			rcall	delay200ms
			rjmp	wait_key

;/***************************************
; scan key by clear column to zero
;/***************************************
scan_key:	ser	Column
			out	DDRB,Column
			cbr	Column,Col
			ldi	counter3,4			;clear Column Counter
scan_key1:	out	PORT_KBI,Column		;send column data to keypad port
			rcall	read_pin		;read data
			andi	temp,0x0F
			cpi	temp,0x0F
			brne	press
			sec						;set carry flag
			rol	Column				;rotate left column register with carry 
			dec	counter3
			breq	scan_key
			rjmp	scan_key1	

;/*************************************************
; if pressed key,delay30ms and check key again 
;**************************************************
press:		rcall	delay30ms		;Debounce key
			out	PORT_KBI,Column		;check status of key again
			rcall	read_pin
			andi	temp,$0F
			cpi	temp,$0F
			breq	scan_key1		 
			andi	Column,$F0
			or	Column,temp
			ldi	data,0
			ldi	counter3,16
			ldi	ZL,low(2*KEY_TAB)
			ldi	ZH,high(2*KEY_TAB)
key_code:	lpm
			set
			cp	r0,Column
			breq	end_scan
			inc	data
			adiw	ZL,1
			dec	counter3
			brne	key_code
			clt
end_scan:	ret

;/**************************
; Read data from PORT_KBI
;/**************************
read_pin:	clr	temp1
			out	DDR_KBI,temp1		;clear PORTB as input
			in	temp,PIN_KBI		;read pin
			ser	temp1
			out	DDR_KBI,temp1
			ret

;/***********
; Send data
;/***********
Intro:		lpm
			tst	r0
			breq	end_sub
TX232:		sbis	USR,UDRE
			rjmp	TX232
			out	UDR,r0
			adiw	ZL,1
			rcall	delay1ms
			rjmp	Intro
end_sub:	ret		

TX_Byte:	sbis	USR,UDRE
			rjmp	TX_Byte
			out	UDR,data
			ret

RX_Byte:	sbis	USR,RXC
			rjmp	RX_Byte
			in	data,UDR
			ret

;/*****************
; delay time
;/*****************
delay1ms:	push	counter1
			push	counter2
			ldi	counter1,8
delay1ms_1: ldi    	counter2,250
delay1ms_2: nop
			dec    	counter2
            brne   	delay1ms_2
            dec    	counter1
            brne   	delay1ms_1
            pop	counter2
			pop	counter1
			ret          

delay10ms:	push	counter1
			push	counter2
			ldi    	counter1,80
delay10ms_1:   	
			ldi    	counter2,250
delay10ms_2:   	
			nop
			dec    	counter2
            brne   	delay10ms_2
            dec    	counter1
            brne   	delay10ms_1
            pop	counter2
			pop	counter1
			ret          

delay30ms:	ldi    	counter1,240
delay30ms_1:   	
			ldi    	counter2,250
delay30ms_2:   	
			nop
			dec    	counter2
            brne   	delay30ms_2
            dec    	counter1
            brne   	delay30ms_1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret

;/******************
; code segment
;/******************
KEY_TAB: 	.db	0x7D,0xEE,0xED,0xEB		;0 1 2 3
			.db	0xDE,0xDD,0xDB,0xBE		;4 5 6 7
			.db	0xBD,0xBB,0x7E,0x7B		;8 9 A B
			.db	0x77,0xB7,0xD7,0xE7		;C D E F

Key4x4TB:	.db	0x0a,0x0d,"Test a 4x4 metrix Keyboard",0x0a,0x0d,"Please press any key"
			.db	0x0a,0x0d,"You pressed :",0
           	 